/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangedFile
implements Comparable<ChangedFile> {
    private final GitRepository repo;
    private final IPath path;
    final Status status;
    private boolean hasStagedChanges;
    private boolean hasUnstagedChanges;
    private final String commitBlobSHA;
    private final String commitBlobMode;

    private ChangedFile(ChangedFile other) {
        this(other.repo, other.path, other.status, other.commitBlobMode, other.commitBlobSHA, other.hasStagedChanges, other.hasUnstagedChanges);
    }

    public ChangedFile(GitRepository repository, IPath path, Status status, String mode, String sha, boolean staged, boolean unstaged) {
        this.repo = repository;
        this.path = path;
        this.status = status;
        this.commitBlobMode = mode;
        this.commitBlobSHA = sha;
        this.hasStagedChanges = staged;
        this.hasUnstagedChanges = unstaged;
    }

    public IPath getRelativePath() {
        return this.path;
    }

    public Status getStatus() {
        return this.status;
    }

    public void makeStaged() {
        this.hasUnstagedChanges = false;
        this.hasStagedChanges = true;
    }

    public void makeUnstaged() {
        this.hasUnstagedChanges = true;
        this.hasStagedChanges = false;
    }

    public void setUnstaged(boolean unstaged) {
        this.hasUnstagedChanges = unstaged;
    }

    public boolean hasStagedChanges() {
        return this.hasStagedChanges;
    }

    public boolean hasUnstagedChanges() {
        return this.hasUnstagedChanges;
    }

    public String getCommitBlobSHA() {
        return this.commitBlobSHA;
    }

    public String getCommitBlobMode() {
        return this.commitBlobMode;
    }

    protected String indexInfo() {
        Assert.isTrue((this.status == Status.NEW || this.commitBlobSHA != null ? 1 : 0) != 0, (String)"File is not new, but doesn't have an index entry!");
        if (this.commitBlobSHA == null) {
            return MessageFormat.format("0 0000000000000000000000000000000000000000\t{0}\u0000", this.path.toPortableString());
        }
        return MessageFormat.format("{0} {1}\t{2}\u0000", this.commitBlobMode, this.commitBlobSHA, this.path.toPortableString());
    }

    public String toString() {
        return MessageFormat.format("{0} {1} (Staged? {2}, Unstaged? {3})", new Object[]{this.status, this.path.toOSString(), this.hasStagedChanges, this.hasUnstagedChanges});
    }

    public boolean hasUnmergedChanges() {
        return this.status == Status.UNMERGED;
    }

    @Override
    public int compareTo(ChangedFile o) {
        return this.path.toPortableString().compareTo(o.path.toPortableString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangedFile) {
            ChangedFile other = (ChangedFile)obj;
            return this.hasStagedChanges == other.hasStagedChanges && this.hasUnstagedChanges == other.hasUnstagedChanges && this.status == other.status && this.path.equals((Object)other.path);
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 + Boolean.valueOf(this.hasStagedChanges).hashCode();
        hash = hash * 31 + Boolean.valueOf(this.hasUnstagedChanges).hashCode();
        hash = hash * 31 + this.status.hashCode();
        hash = hash * 31 + this.path.hashCode();
        return hash;
    }

    public ChangedFile clone() {
        return new ChangedFile(this);
    }

    public ChangedFile merge(ChangedFile other) {
        String sha;
        String mode = this.commitBlobMode;
        if (mode == null) {
            mode = other.commitBlobMode;
        }
        if ((sha = this.commitBlobSHA) == null) {
            sha = other.commitBlobSHA;
        }
        if (this.status != other.status) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)("Mismatch statuses when merging. Who wins? " + this.status.name() + ", " + other.status.name()));
        }
        return new ChangedFile(this.repo, this.path, this.status, mode, sha, this.hasStagedChanges || other.hasStagedChanges, this.hasUnstagedChanges || other.hasUnstagedChanges);
    }

    public GitRepository getRepository() {
        return this.repo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        DELETED,
        MODIFIED,
        UNMERGED;

    }
}

